package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{CisScanArn, AccountId}
import scala.jdk.CollectionConverters.*
final case class CisCheckAggregation(
    accountId: Optional[AccountId] = Optional.Absent,
    checkDescription: Optional[String] = Optional.Absent,
    checkId: Optional[String] = Optional.Absent,
    level: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    scanArn: CisScanArn,
    statusCounts: Optional[zio.aws.inspector2.model.StatusCounts] =
      Optional.Absent,
    title: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisCheckAggregation = {
    import CisCheckAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisCheckAggregation
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(checkDescription.map(value => value: java.lang.String))(
        _.checkDescription
      )
      .optionallyWith(checkId.map(value => value: java.lang.String))(_.checkId)
      .optionallyWith(level.map(value => value.unwrap))(_.level)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(statusCounts.map(value => value.buildAwsValue()))(
        _.statusCounts
      )
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisCheckAggregation.ReadOnly =
    zio.aws.inspector2.model.CisCheckAggregation.wrap(buildAwsValue())
}
object CisCheckAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisCheckAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisCheckAggregation =
      zio.aws.inspector2.model.CisCheckAggregation(
        accountId.map(value => value),
        checkDescription.map(value => value),
        checkId.map(value => value),
        level.map(value => value),
        platform.map(value => value),
        scanArn,
        statusCounts.map(value => value.asEditable),
        title.map(value => value)
      )
    def accountId: Optional[AccountId]
    def checkDescription: Optional[String]
    def checkId: Optional[String]
    def level: Optional[zio.aws.inspector2.model.CisSecurityLevel]
    def platform: Optional[String]
    def scanArn: CisScanArn
    def statusCounts: Optional[zio.aws.inspector2.model.StatusCounts.ReadOnly]
    def title: Optional[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCheckDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checkDescription", checkDescription)
    def getCheckId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checkId", checkId)
    def getLevel
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSecurityLevel] =
      AwsError.unwrapOptionField("level", level)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getStatusCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StatusCounts.ReadOnly] =
      AwsError.unwrapOptionField("statusCounts", statusCounts)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisCheckAggregation
  ) extends zio.aws.inspector2.model.CisCheckAggregation.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val checkDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checkDescription())
      .map(value => value: String)
    override val checkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checkId())
      .map(value => value: String)
    override val level: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.level())
        .map(value => zio.aws.inspector2.model.CisSecurityLevel.wrap(value))
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val statusCounts
        : Optional[zio.aws.inspector2.model.StatusCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCounts())
        .map(value => zio.aws.inspector2.model.StatusCounts.wrap(value))
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisCheckAggregation
  ): zio.aws.inspector2.model.CisCheckAggregation.ReadOnly = new Wrapper(impl)
}
