package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CisDateFilter(
    earliestScanStartTime: Optional[Timestamp] = Optional.Absent,
    latestScanStartTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisDateFilter = {
    import CisDateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisDateFilter
      .builder()
      .optionallyWith(
        earliestScanStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.earliestScanStartTime)
      .optionallyWith(
        latestScanStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestScanStartTime)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisDateFilter.ReadOnly =
    zio.aws.inspector2.model.CisDateFilter.wrap(buildAwsValue())
}
object CisDateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisDateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisDateFilter =
      zio.aws.inspector2.model.CisDateFilter(
        earliestScanStartTime.map(value => value),
        latestScanStartTime.map(value => value)
      )
    def earliestScanStartTime: Optional[Timestamp]
    def latestScanStartTime: Optional[Timestamp]
    def getEarliestScanStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("earliestScanStartTime", earliestScanStartTime)
    def getLatestScanStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestScanStartTime", latestScanStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisDateFilter
  ) extends zio.aws.inspector2.model.CisDateFilter.ReadOnly {
    override val earliestScanStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.earliestScanStartTime())
        .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
    override val latestScanStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScanStartTime())
        .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisDateFilter
  ): zio.aws.inspector2.model.CisDateFilter.ReadOnly = new Wrapper(impl)
}
