package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisFindingStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisFindingStatus
}
object CisFindingStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisFindingStatus
  ): zio.aws.inspector2.model.CisFindingStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.CisFindingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisFindingStatus.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.inspector2.model.CisFindingStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.CisFindingStatus.SKIPPED =>
      val r = SKIPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisFindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisFindingStatus =
      software.amazon.awssdk.services.inspector2.model.CisFindingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PASSED extends zio.aws.inspector2.model.CisFindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisFindingStatus =
      software.amazon.awssdk.services.inspector2.model.CisFindingStatus.PASSED
  }
  case object FAILED extends zio.aws.inspector2.model.CisFindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisFindingStatus =
      software.amazon.awssdk.services.inspector2.model.CisFindingStatus.FAILED
  }
  case object SKIPPED extends zio.aws.inspector2.model.CisFindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisFindingStatus =
      software.amazon.awssdk.services.inspector2.model.CisFindingStatus.SKIPPED
  }
}
