package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CisFindingStatusFilter(
    comparison: zio.aws.inspector2.model.CisFindingStatusComparison,
    value: zio.aws.inspector2.model.CisFindingStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter = {
    import CisFindingStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisFindingStatusFilter.ReadOnly =
    zio.aws.inspector2.model.CisFindingStatusFilter.wrap(buildAwsValue())
}
object CisFindingStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisFindingStatusFilter =
      zio.aws.inspector2.model.CisFindingStatusFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CisFindingStatusComparison
    def value: zio.aws.inspector2.model.CisFindingStatus
    def getComparison: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.CisFindingStatusComparison
    ] = ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, zio.aws.inspector2.model.CisFindingStatus] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter
  ) extends zio.aws.inspector2.model.CisFindingStatusFilter.ReadOnly {
    override val comparison
        : zio.aws.inspector2.model.CisFindingStatusComparison =
      zio.aws.inspector2.model.CisFindingStatusComparison
        .wrap(impl.comparison())
    override val value: zio.aws.inspector2.model.CisFindingStatus =
      zio.aws.inspector2.model.CisFindingStatus.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter
  ): zio.aws.inspector2.model.CisFindingStatusFilter.ReadOnly = new Wrapper(
    impl
  )
}
