package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class CisNumberFilter(
    lowerInclusive: Optional[Integer] = Optional.Absent,
    upperInclusive: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisNumberFilter = {
    import CisNumberFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisNumberFilter
      .builder()
      .optionallyWith(lowerInclusive.map(value => value: java.lang.Integer))(
        _.lowerInclusive
      )
      .optionallyWith(upperInclusive.map(value => value: java.lang.Integer))(
        _.upperInclusive
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisNumberFilter.ReadOnly =
    zio.aws.inspector2.model.CisNumberFilter.wrap(buildAwsValue())
}
object CisNumberFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisNumberFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisNumberFilter =
      zio.aws.inspector2.model.CisNumberFilter(
        lowerInclusive.map(value => value),
        upperInclusive.map(value => value)
      )
    def lowerInclusive: Optional[Integer]
    def upperInclusive: Optional[Integer]
    def getLowerInclusive: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("lowerInclusive", lowerInclusive)
    def getUpperInclusive: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("upperInclusive", upperInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisNumberFilter
  ) extends zio.aws.inspector2.model.CisNumberFilter.ReadOnly {
    override val lowerInclusive: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.lowerInclusive())
      .map(value => value: Integer)
    override val upperInclusive: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.upperInclusive())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisNumberFilter
  ): zio.aws.inspector2.model.CisNumberFilter.ReadOnly = new Wrapper(impl)
}
