package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisReportFormat {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisReportFormat
}
object CisReportFormat {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisReportFormat
  ): zio.aws.inspector2.model.CisReportFormat = value match {
    case software.amazon.awssdk.services.inspector2.model.CisReportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisReportFormat.PDF =>
      val r = PDF
      r
    case software.amazon.awssdk.services.inspector2.model.CisReportFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportFormat =
      software.amazon.awssdk.services.inspector2.model.CisReportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object PDF extends zio.aws.inspector2.model.CisReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportFormat =
      software.amazon.awssdk.services.inspector2.model.CisReportFormat.PDF
  }
  case object CSV extends zio.aws.inspector2.model.CisReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportFormat =
      software.amazon.awssdk.services.inspector2.model.CisReportFormat.CSV
  }
}
