package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisReportStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisReportStatus
}
object CisReportStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisReportStatus
  ): zio.aws.inspector2.model.CisReportStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.CisReportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisReportStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.inspector2.model.CisReportStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.CisReportStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportStatus =
      software.amazon.awssdk.services.inspector2.model.CisReportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.inspector2.model.CisReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportStatus =
      software.amazon.awssdk.services.inspector2.model.CisReportStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.inspector2.model.CisReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportStatus =
      software.amazon.awssdk.services.inspector2.model.CisReportStatus.FAILED
  }
  case object IN_PROGRESS extends zio.aws.inspector2.model.CisReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisReportStatus =
      software.amazon.awssdk.services.inspector2.model.CisReportStatus.IN_PROGRESS
  }
}
