package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisResultStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisResultStatus
}
object CisResultStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisResultStatus
  ): zio.aws.inspector2.model.CisResultStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.CisResultStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisResultStatus.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.inspector2.model.CisResultStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.CisResultStatus.SKIPPED =>
      val r = SKIPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisResultStatus =
      software.amazon.awssdk.services.inspector2.model.CisResultStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PASSED extends zio.aws.inspector2.model.CisResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisResultStatus =
      software.amazon.awssdk.services.inspector2.model.CisResultStatus.PASSED
  }
  case object FAILED extends zio.aws.inspector2.model.CisResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisResultStatus =
      software.amazon.awssdk.services.inspector2.model.CisResultStatus.FAILED
  }
  case object SKIPPED extends zio.aws.inspector2.model.CisResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisResultStatus =
      software.amazon.awssdk.services.inspector2.model.CisResultStatus.SKIPPED
  }
}
