package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CisResultStatusFilter(
    comparison: zio.aws.inspector2.model.CisResultStatusComparison,
    value: zio.aws.inspector2.model.CisResultStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter = {
    import CisResultStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisResultStatusFilter.ReadOnly =
    zio.aws.inspector2.model.CisResultStatusFilter.wrap(buildAwsValue())
}
object CisResultStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisResultStatusFilter =
      zio.aws.inspector2.model.CisResultStatusFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CisResultStatusComparison
    def value: zio.aws.inspector2.model.CisResultStatus
    def getComparison: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.CisResultStatusComparison
    ] = ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, zio.aws.inspector2.model.CisResultStatus] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter
  ) extends zio.aws.inspector2.model.CisResultStatusFilter.ReadOnly {
    override val comparison
        : zio.aws.inspector2.model.CisResultStatusComparison =
      zio.aws.inspector2.model.CisResultStatusComparison.wrap(impl.comparison())
    override val value: zio.aws.inspector2.model.CisResultStatus =
      zio.aws.inspector2.model.CisResultStatus.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter
  ): zio.aws.inspector2.model.CisResultStatusFilter.ReadOnly = new Wrapper(impl)
}
