package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisRuleStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisRuleStatus
}
object CisRuleStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisRuleStatus
  ): zio.aws.inspector2.model.CisRuleStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.NOT_EVALUATED =>
      val r = NOT_EVALUATED
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.INFORMATIONAL =>
      val r = INFORMATIONAL
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.NOT_APPLICABLE =>
      val r = NOT_APPLICABLE
      r
    case software.amazon.awssdk.services.inspector2.model.CisRuleStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.FAILED
  }
  case object PASSED extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.PASSED
  }
  case object NOT_EVALUATED extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.NOT_EVALUATED
  }
  case object INFORMATIONAL extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.INFORMATIONAL
  }
  case object UNKNOWN extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.UNKNOWN
  }
  case object NOT_APPLICABLE extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.NOT_APPLICABLE
  }
  case object ERROR extends zio.aws.inspector2.model.CisRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisRuleStatus =
      software.amazon.awssdk.services.inspector2.model.CisRuleStatus.ERROR
  }
}
