package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  Timestamp,
  CisScanArn,
  Integer,
  CisScanConfigurationArn,
  CisScanName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CisScan(
    failedChecks: Optional[Integer] = Optional.Absent,
    scanArn: CisScanArn,
    scanConfigurationArn: CisScanConfigurationArn,
    scanDate: Optional[Timestamp] = Optional.Absent,
    scanName: Optional[CisScanName] = Optional.Absent,
    scheduledBy: Optional[String] = Optional.Absent,
    securityLevel: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      Optional.Absent,
    status: Optional[zio.aws.inspector2.model.CisScanStatus] = Optional.Absent,
    targets: Optional[zio.aws.inspector2.model.CisTargets] = Optional.Absent,
    totalChecks: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScan = {
    import CisScan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScan
      .builder()
      .optionallyWith(failedChecks.map(value => value: java.lang.Integer))(
        _.failedChecks
      )
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .scanConfigurationArn(
        CisScanConfigurationArn.unwrap(scanConfigurationArn): java.lang.String
      )
      .optionallyWith(scanDate.map(value => Timestamp.unwrap(value): Instant))(
        _.scanDate
      )
      .optionallyWith(
        scanName.map(value => CisScanName.unwrap(value): java.lang.String)
      )(_.scanName)
      .optionallyWith(scheduledBy.map(value => value: java.lang.String))(
        _.scheduledBy
      )
      .optionallyWith(securityLevel.map(value => value.unwrap))(_.securityLevel)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(targets.map(value => value.buildAwsValue()))(_.targets)
      .optionallyWith(totalChecks.map(value => value: java.lang.Integer))(
        _.totalChecks
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisScan.ReadOnly =
    zio.aws.inspector2.model.CisScan.wrap(buildAwsValue())
}
object CisScan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisScan =
      zio.aws.inspector2.model.CisScan(
        failedChecks.map(value => value),
        scanArn,
        scanConfigurationArn,
        scanDate.map(value => value),
        scanName.map(value => value),
        scheduledBy.map(value => value),
        securityLevel.map(value => value),
        status.map(value => value),
        targets.map(value => value.asEditable),
        totalChecks.map(value => value)
      )
    def failedChecks: Optional[Integer]
    def scanArn: CisScanArn
    def scanConfigurationArn: CisScanConfigurationArn
    def scanDate: Optional[Timestamp]
    def scanName: Optional[CisScanName]
    def scheduledBy: Optional[String]
    def securityLevel: Optional[zio.aws.inspector2.model.CisSecurityLevel]
    def status: Optional[zio.aws.inspector2.model.CisScanStatus]
    def targets: Optional[zio.aws.inspector2.model.CisTargets.ReadOnly]
    def totalChecks: Optional[Integer]
    def getFailedChecks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedChecks", failedChecks)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getScanConfigurationArn: ZIO[Any, Nothing, CisScanConfigurationArn] =
      ZIO.succeed(scanConfigurationArn)
    def getScanDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scanDate", scanDate)
    def getScanName: ZIO[Any, AwsError, CisScanName] =
      AwsError.unwrapOptionField("scanName", scanName)
    def getScheduledBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduledBy", scheduledBy)
    def getSecurityLevel
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSecurityLevel] =
      AwsError.unwrapOptionField("securityLevel", securityLevel)
    def getStatus: ZIO[Any, AwsError, zio.aws.inspector2.model.CisScanStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTargets
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisTargets.ReadOnly] =
      AwsError.unwrapOptionField("targets", targets)
    def getTotalChecks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalChecks", totalChecks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScan
  ) extends zio.aws.inspector2.model.CisScan.ReadOnly {
    override val failedChecks: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedChecks())
      .map(value => value: Integer)
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val scanConfigurationArn: CisScanConfigurationArn =
      zio.aws.inspector2.model.primitives
        .CisScanConfigurationArn(impl.scanConfigurationArn())
    override val scanDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scanDate())
      .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
    override val scanName: Optional[CisScanName] = zio.aws.core.internal
      .optionalFromNullable(impl.scanName())
      .map(value => zio.aws.inspector2.model.primitives.CisScanName(value))
    override val scheduledBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledBy())
      .map(value => value: String)
    override val securityLevel
        : Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityLevel())
        .map(value => zio.aws.inspector2.model.CisSecurityLevel.wrap(value))
    override val status: Optional[zio.aws.inspector2.model.CisScanStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.CisScanStatus.wrap(value))
    override val targets
        : Optional[zio.aws.inspector2.model.CisTargets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value => zio.aws.inspector2.model.CisTargets.wrap(value))
    override val totalChecks: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalChecks())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScan
  ): zio.aws.inspector2.model.CisScan.ReadOnly = new Wrapper(impl)
}
