package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  MapKey,
  CisScanConfigurationArn,
  CisScanName,
  CisOwnerId,
  MapValue
}
import scala.jdk.CollectionConverters.*
final case class CisScanConfiguration(
    ownerId: Optional[CisOwnerId] = Optional.Absent,
    scanConfigurationArn: CisScanConfigurationArn,
    scanName: Optional[CisScanName] = Optional.Absent,
    schedule: Optional[zio.aws.inspector2.model.Schedule] = Optional.Absent,
    securityLevel: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      Optional.Absent,
    tags: Optional[Map[MapKey, MapValue]] = Optional.Absent,
    targets: Optional[zio.aws.inspector2.model.CisTargets] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScanConfiguration = {
    import CisScanConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScanConfiguration
      .builder()
      .optionallyWith(
        ownerId.map(value => CisOwnerId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .scanConfigurationArn(
        CisScanConfigurationArn.unwrap(scanConfigurationArn): java.lang.String
      )
      .optionallyWith(
        scanName.map(value => CisScanName.unwrap(value): java.lang.String)
      )(_.scanName)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(securityLevel.map(value => value.unwrap))(_.securityLevel)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(targets.map(value => value.buildAwsValue()))(_.targets)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisScanConfiguration.ReadOnly =
    zio.aws.inspector2.model.CisScanConfiguration.wrap(buildAwsValue())
}
object CisScanConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScanConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisScanConfiguration =
      zio.aws.inspector2.model.CisScanConfiguration(
        ownerId.map(value => value),
        scanConfigurationArn,
        scanName.map(value => value),
        schedule.map(value => value.asEditable),
        securityLevel.map(value => value),
        tags.map(value => value),
        targets.map(value => value.asEditable)
      )
    def ownerId: Optional[CisOwnerId]
    def scanConfigurationArn: CisScanConfigurationArn
    def scanName: Optional[CisScanName]
    def schedule: Optional[zio.aws.inspector2.model.Schedule.ReadOnly]
    def securityLevel: Optional[zio.aws.inspector2.model.CisSecurityLevel]
    def tags: Optional[Map[MapKey, MapValue]]
    def targets: Optional[zio.aws.inspector2.model.CisTargets.ReadOnly]
    def getOwnerId: ZIO[Any, AwsError, CisOwnerId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getScanConfigurationArn: ZIO[Any, Nothing, CisScanConfigurationArn] =
      ZIO.succeed(scanConfigurationArn)
    def getScanName: ZIO[Any, AwsError, CisScanName] =
      AwsError.unwrapOptionField("scanName", scanName)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSecurityLevel
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSecurityLevel] =
      AwsError.unwrapOptionField("securityLevel", securityLevel)
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargets
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisTargets.ReadOnly] =
      AwsError.unwrapOptionField("targets", targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanConfiguration
  ) extends zio.aws.inspector2.model.CisScanConfiguration.ReadOnly {
    override val ownerId: Optional[CisOwnerId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.inspector2.model.primitives.CisOwnerId(value))
    override val scanConfigurationArn: CisScanConfigurationArn =
      zio.aws.inspector2.model.primitives
        .CisScanConfigurationArn(impl.scanConfigurationArn())
    override val scanName: Optional[CisScanName] = zio.aws.core.internal
      .optionalFromNullable(impl.scanName())
      .map(value => zio.aws.inspector2.model.primitives.CisScanName(value))
    override val schedule
        : Optional[zio.aws.inspector2.model.Schedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.inspector2.model.Schedule.wrap(value))
    override val securityLevel
        : Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityLevel())
        .map(value => zio.aws.inspector2.model.CisSecurityLevel.wrap(value))
    override val tags: Optional[Map[MapKey, MapValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
    override val targets
        : Optional[zio.aws.inspector2.model.CisTargets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value => zio.aws.inspector2.model.CisTargets.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanConfiguration
  ): zio.aws.inspector2.model.CisScanConfiguration.ReadOnly = new Wrapper(impl)
}
