package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  ResourceId,
  CisScanArn,
  CisFindingArn,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class CisScanResultDetails(
    accountId: Optional[AccountId] = Optional.Absent,
    checkDescription: Optional[String] = Optional.Absent,
    checkId: Optional[String] = Optional.Absent,
    findingArn: Optional[CisFindingArn] = Optional.Absent,
    level: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    remediation: Optional[String] = Optional.Absent,
    scanArn: CisScanArn,
    status: Optional[zio.aws.inspector2.model.CisFindingStatus] =
      Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    targetResourceId: Optional[ResourceId] = Optional.Absent,
    title: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScanResultDetails = {
    import CisScanResultDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScanResultDetails
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(checkDescription.map(value => value: java.lang.String))(
        _.checkDescription
      )
      .optionallyWith(checkId.map(value => value: java.lang.String))(_.checkId)
      .optionallyWith(
        findingArn.map(value => CisFindingArn.unwrap(value): java.lang.String)
      )(_.findingArn)
      .optionallyWith(level.map(value => value.unwrap))(_.level)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(remediation.map(value => value: java.lang.String))(
        _.remediation
      )
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        targetResourceId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.targetResourceId)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisScanResultDetails.ReadOnly =
    zio.aws.inspector2.model.CisScanResultDetails.wrap(buildAwsValue())
}
object CisScanResultDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScanResultDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisScanResultDetails =
      zio.aws.inspector2.model.CisScanResultDetails(
        accountId.map(value => value),
        checkDescription.map(value => value),
        checkId.map(value => value),
        findingArn.map(value => value),
        level.map(value => value),
        platform.map(value => value),
        remediation.map(value => value),
        scanArn,
        status.map(value => value),
        statusReason.map(value => value),
        targetResourceId.map(value => value),
        title.map(value => value)
      )
    def accountId: Optional[AccountId]
    def checkDescription: Optional[String]
    def checkId: Optional[String]
    def findingArn: Optional[CisFindingArn]
    def level: Optional[zio.aws.inspector2.model.CisSecurityLevel]
    def platform: Optional[String]
    def remediation: Optional[String]
    def scanArn: CisScanArn
    def status: Optional[zio.aws.inspector2.model.CisFindingStatus]
    def statusReason: Optional[String]
    def targetResourceId: Optional[ResourceId]
    def title: Optional[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCheckDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checkDescription", checkDescription)
    def getCheckId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checkId", checkId)
    def getFindingArn: ZIO[Any, AwsError, CisFindingArn] =
      AwsError.unwrapOptionField("findingArn", findingArn)
    def getLevel
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSecurityLevel] =
      AwsError.unwrapOptionField("level", level)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getRemediation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remediation", remediation)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisFindingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTargetResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("targetResourceId", targetResourceId)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultDetails
  ) extends zio.aws.inspector2.model.CisScanResultDetails.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val checkDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checkDescription())
      .map(value => value: String)
    override val checkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checkId())
      .map(value => value: String)
    override val findingArn: Optional[CisFindingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.findingArn())
      .map(value => zio.aws.inspector2.model.primitives.CisFindingArn(value))
    override val level: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.level())
        .map(value => zio.aws.inspector2.model.CisSecurityLevel.wrap(value))
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val remediation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.remediation())
      .map(value => value: String)
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val status: Optional[zio.aws.inspector2.model.CisFindingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.CisFindingStatus.wrap(value))
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val targetResourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetResourceId())
      .map(value => zio.aws.inspector2.model.primitives.ResourceId(value))
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultDetails
  ): zio.aws.inspector2.model.CisScanResultDetails.ReadOnly = new Wrapper(impl)
}
