package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CisScanResultDetailsFilterCriteria(
    checkIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    findingArnFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    findingStatusFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisFindingStatusFilter]
    ] = Optional.Absent,
    securityLevelFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisSecurityLevelFilter]
    ] = Optional.Absent,
    titleFilters: Optional[Iterable[zio.aws.inspector2.model.CisStringFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsFilterCriteria = {
    import CisScanResultDetailsFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsFilterCriteria
      .builder()
      .optionallyWith(
        checkIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.checkIdFilters)
      .optionallyWith(
        findingArnFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingArnFilters)
      .optionallyWith(
        findingStatusFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingStatusFilters)
      .optionallyWith(
        securityLevelFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityLevelFilters)
      .optionallyWith(
        titleFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.titleFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria
      .wrap(buildAwsValue())
}
object CisScanResultDetailsFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria =
      zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria(
        checkIdFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingArnFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingStatusFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityLevelFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        titleFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def checkIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def findingArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def findingStatusFilters: Optional[
      List[zio.aws.inspector2.model.CisFindingStatusFilter.ReadOnly]
    ]
    def securityLevelFilters: Optional[
      List[zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly]
    ]
    def titleFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def getCheckIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("checkIdFilters", checkIdFilters)
    def getFindingArnFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingArnFilters", findingArnFilters)
    def getFindingStatusFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisFindingStatusFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("findingStatusFilters", findingStatusFilters)
    def getSecurityLevelFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("securityLevelFilters", securityLevelFilters)
    def getTitleFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("titleFilters", titleFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsFilterCriteria
  ) extends zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.ReadOnly {
    override val checkIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val findingArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingArnFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val findingStatusFilters: Optional[
      List[zio.aws.inspector2.model.CisFindingStatusFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.findingStatusFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisFindingStatusFilter.wrap(item)
        }.toList
      )
    override val securityLevelFilters: Optional[
      List[zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityLevelFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisSecurityLevelFilter.wrap(item)
        }.toList
      )
    override val titleFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.titleFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsFilterCriteria
  ): zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.ReadOnly =
    new Wrapper(impl)
}
