package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CisScanResultsAggregatedByChecksFilterCriteria(
    accountIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    checkIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    failedResourcesFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisNumberFilter]
    ] = Optional.Absent,
    platformFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    securityLevelFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisSecurityLevelFilter]
    ] = Optional.Absent,
    titleFilters: Optional[Iterable[zio.aws.inspector2.model.CisStringFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria = {
    import CisScanResultsAggregatedByChecksFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
      .builder()
      .optionallyWith(
        accountIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountIdFilters)
      .optionallyWith(
        checkIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.checkIdFilters)
      .optionallyWith(
        failedResourcesFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedResourcesFilters)
      .optionallyWith(
        platformFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformFilters)
      .optionallyWith(
        securityLevelFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityLevelFilters)
      .optionallyWith(
        titleFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.titleFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
      .wrap(buildAwsValue())
}
object CisScanResultsAggregatedByChecksFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria =
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria(
        accountIdFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        checkIdFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedResourcesFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityLevelFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        titleFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def checkIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def failedResourcesFilters
        : Optional[List[zio.aws.inspector2.model.CisNumberFilter.ReadOnly]]
    def platformFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def securityLevelFilters: Optional[
      List[zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly]
    ]
    def titleFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def getAccountIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountIdFilters", accountIdFilters)
    def getCheckIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("checkIdFilters", checkIdFilters)
    def getFailedResourcesFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisNumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "failedResourcesFilters",
      failedResourcesFilters
    )
    def getPlatformFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("platformFilters", platformFilters)
    def getSecurityLevelFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("securityLevelFilters", securityLevelFilters)
    def getTitleFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("titleFilters", titleFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
  ) extends zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria.ReadOnly {
    override val accountIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val checkIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val failedResourcesFilters
        : Optional[List[zio.aws.inspector2.model.CisNumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedResourcesFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisNumberFilter.wrap(item)
          }.toList
        )
    override val platformFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val securityLevelFilters: Optional[
      List[zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityLevelFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisSecurityLevelFilter.wrap(item)
        }.toList
      )
    override val titleFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.titleFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
  ): zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria.ReadOnly =
    new Wrapper(impl)
}
