package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CisScanResultsAggregatedByTargetResourceFilterCriteria(
    accountIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    checkIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    failedChecksFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisNumberFilter]
    ] = Optional.Absent,
    platformFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    statusFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisResultStatusFilter]
    ] = Optional.Absent,
    targetResourceIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    targetResourceTagFilters: Optional[
      Iterable[zio.aws.inspector2.model.TagFilter]
    ] = Optional.Absent,
    targetStatusFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisTargetStatusFilter]
    ] = Optional.Absent,
    targetStatusReasonFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisTargetStatusReasonFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria = {
    import CisScanResultsAggregatedByTargetResourceFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
      .builder()
      .optionallyWith(
        accountIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountIdFilters)
      .optionallyWith(
        checkIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.checkIdFilters)
      .optionallyWith(
        failedChecksFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedChecksFilters)
      .optionallyWith(
        platformFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformFilters)
      .optionallyWith(
        statusFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusFilters)
      .optionallyWith(
        targetResourceIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetResourceIdFilters)
      .optionallyWith(
        targetResourceTagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetResourceTagFilters)
      .optionallyWith(
        targetStatusFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetStatusFilters)
      .optionallyWith(
        targetStatusReasonFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetStatusReasonFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
      .wrap(buildAwsValue())
}
object CisScanResultsAggregatedByTargetResourceFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria =
      zio.aws.inspector2.model
        .CisScanResultsAggregatedByTargetResourceFilterCriteria(
          accountIdFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          checkIdFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          failedChecksFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          platformFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          statusFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          targetResourceIdFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          targetResourceTagFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          targetStatusFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          targetStatusReasonFilters.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def accountIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def checkIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def failedChecksFilters
        : Optional[List[zio.aws.inspector2.model.CisNumberFilter.ReadOnly]]
    def platformFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def statusFilters: Optional[
      List[zio.aws.inspector2.model.CisResultStatusFilter.ReadOnly]
    ]
    def targetResourceIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def targetResourceTagFilters
        : Optional[List[zio.aws.inspector2.model.TagFilter.ReadOnly]]
    def targetStatusFilters: Optional[
      List[zio.aws.inspector2.model.CisTargetStatusFilter.ReadOnly]
    ]
    def targetStatusReasonFilters: Optional[
      List[zio.aws.inspector2.model.CisTargetStatusReasonFilter.ReadOnly]
    ]
    def getAccountIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountIdFilters", accountIdFilters)
    def getCheckIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("checkIdFilters", checkIdFilters)
    def getFailedChecksFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisNumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("failedChecksFilters", failedChecksFilters)
    def getPlatformFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("platformFilters", platformFilters)
    def getStatusFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisResultStatusFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("statusFilters", statusFilters)
    def getTargetResourceIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetResourceIdFilters",
      targetResourceIdFilters
    )
    def getTargetResourceTagFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetResourceTagFilters",
      targetResourceTagFilters
    )
    def getTargetStatusFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisTargetStatusFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("targetStatusFilters", targetStatusFilters)
    def getTargetStatusReasonFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisTargetStatusReasonFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetStatusReasonFilters",
      targetStatusReasonFilters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
  ) extends zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria.ReadOnly {
    override val accountIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val checkIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val failedChecksFilters
        : Optional[List[zio.aws.inspector2.model.CisNumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedChecksFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisNumberFilter.wrap(item)
          }.toList
        )
    override val platformFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val statusFilters: Optional[
      List[zio.aws.inspector2.model.CisResultStatusFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisResultStatusFilter.wrap(item)
        }.toList
      )
    override val targetResourceIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val targetResourceTagFilters
        : Optional[List[zio.aws.inspector2.model.TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceTagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.TagFilter.wrap(item)
          }.toList
        )
    override val targetStatusFilters: Optional[
      List[zio.aws.inspector2.model.CisTargetStatusFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetStatusFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisTargetStatusFilter.wrap(item)
        }.toList
      )
    override val targetStatusReasonFilters: Optional[
      List[zio.aws.inspector2.model.CisTargetStatusReasonFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetStatusReasonFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisTargetStatusReasonFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
  ): zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria.ReadOnly =
    new Wrapper(impl)
}
