package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisScanStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisScanStatus
}
object CisScanStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisScanStatus
  ): zio.aws.inspector2.model.CisScanStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.CisScanStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisScanStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.CisScanStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.inspector2.model.CisScanStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.inspector2.model.CisScanStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisScanStatus =
      software.amazon.awssdk.services.inspector2.model.CisScanStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.inspector2.model.CisScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisScanStatus =
      software.amazon.awssdk.services.inspector2.model.CisScanStatus.FAILED
  }
  case object COMPLETED extends zio.aws.inspector2.model.CisScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisScanStatus =
      software.amazon.awssdk.services.inspector2.model.CisScanStatus.COMPLETED
  }
  case object CANCELLED extends zio.aws.inspector2.model.CisScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisScanStatus =
      software.amazon.awssdk.services.inspector2.model.CisScanStatus.CANCELLED
  }
  case object IN_PROGRESS extends zio.aws.inspector2.model.CisScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisScanStatus =
      software.amazon.awssdk.services.inspector2.model.CisScanStatus.IN_PROGRESS
  }
}
