package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CisScanStatusFilter(
    comparison: zio.aws.inspector2.model.CisScanStatusComparison,
    value: zio.aws.inspector2.model.CisScanStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter = {
    import CisScanStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisScanStatusFilter.ReadOnly =
    zio.aws.inspector2.model.CisScanStatusFilter.wrap(buildAwsValue())
}
object CisScanStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisScanStatusFilter =
      zio.aws.inspector2.model.CisScanStatusFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CisScanStatusComparison
    def value: zio.aws.inspector2.model.CisScanStatus
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CisScanStatusComparison] =
      ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, zio.aws.inspector2.model.CisScanStatus] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter
  ) extends zio.aws.inspector2.model.CisScanStatusFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.CisScanStatusComparison =
      zio.aws.inspector2.model.CisScanStatusComparison.wrap(impl.comparison())
    override val value: zio.aws.inspector2.model.CisScanStatus =
      zio.aws.inspector2.model.CisScanStatus.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter
  ): zio.aws.inspector2.model.CisScanStatusFilter.ReadOnly = new Wrapper(impl)
}
