package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisSecurityLevel {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisSecurityLevel
}
object CisSecurityLevel {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisSecurityLevel
  ): zio.aws.inspector2.model.CisSecurityLevel = value match {
    case software.amazon.awssdk.services.inspector2.model.CisSecurityLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisSecurityLevel.LEVEL_1 =>
      val r = LEVEL_1
      r
    case software.amazon.awssdk.services.inspector2.model.CisSecurityLevel.LEVEL_2 =>
      val r = LEVEL_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisSecurityLevel {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSecurityLevel =
      software.amazon.awssdk.services.inspector2.model.CisSecurityLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object LEVEL_1 extends zio.aws.inspector2.model.CisSecurityLevel {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSecurityLevel =
      software.amazon.awssdk.services.inspector2.model.CisSecurityLevel.LEVEL_1
  }
  case object LEVEL_2 extends zio.aws.inspector2.model.CisSecurityLevel {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSecurityLevel =
      software.amazon.awssdk.services.inspector2.model.CisSecurityLevel.LEVEL_2
  }
}
