package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisSecurityLevelComparison {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison
}
object CisSecurityLevelComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison
  ): zio.aws.inspector2.model.CisSecurityLevelComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison.EQUALS =>
      val r = EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisSecurityLevelComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison =
      software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS
      extends zio.aws.inspector2.model.CisSecurityLevelComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison =
      software.amazon.awssdk.services.inspector2.model.CisSecurityLevelComparison.EQUALS
  }
}
