package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CisSecurityLevelFilter(
    comparison: zio.aws.inspector2.model.CisSecurityLevelComparison,
    value: zio.aws.inspector2.model.CisSecurityLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter = {
    import CisSecurityLevelFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly =
    zio.aws.inspector2.model.CisSecurityLevelFilter.wrap(buildAwsValue())
}
object CisSecurityLevelFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisSecurityLevelFilter =
      zio.aws.inspector2.model.CisSecurityLevelFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CisSecurityLevelComparison
    def value: zio.aws.inspector2.model.CisSecurityLevel
    def getComparison: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.CisSecurityLevelComparison
    ] = ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, zio.aws.inspector2.model.CisSecurityLevel] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter
  ) extends zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly {
    override val comparison
        : zio.aws.inspector2.model.CisSecurityLevelComparison =
      zio.aws.inspector2.model.CisSecurityLevelComparison
        .wrap(impl.comparison())
    override val value: zio.aws.inspector2.model.CisSecurityLevel =
      zio.aws.inspector2.model.CisSecurityLevel.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter
  ): zio.aws.inspector2.model.CisSecurityLevelFilter.ReadOnly = new Wrapper(
    impl
  )
}
