package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{RuleId, CisRuleDetails}
import scala.jdk.CollectionConverters.*
final case class CisSessionMessage(
    cisRuleDetails: CisRuleDetails,
    ruleId: RuleId,
    status: zio.aws.inspector2.model.CisRuleStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisSessionMessage = {
    import CisSessionMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisSessionMessage
      .builder()
      .cisRuleDetails(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(cisRuleDetails.toArray[Byte])
      )
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisSessionMessage.ReadOnly =
    zio.aws.inspector2.model.CisSessionMessage.wrap(buildAwsValue())
}
object CisSessionMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisSessionMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisSessionMessage =
      zio.aws.inspector2.model.CisSessionMessage(cisRuleDetails, ruleId, status)
    def cisRuleDetails: CisRuleDetails
    def ruleId: RuleId
    def status: zio.aws.inspector2.model.CisRuleStatus
    def getCisRuleDetails: ZIO[Any, Nothing, CisRuleDetails] =
      ZIO.succeed(cisRuleDetails)
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
    def getStatus: ZIO[Any, Nothing, zio.aws.inspector2.model.CisRuleStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisSessionMessage
  ) extends zio.aws.inspector2.model.CisSessionMessage.ReadOnly {
    override val cisRuleDetails: CisRuleDetails =
      zio.aws.inspector2.model.primitives.CisRuleDetails(
        zio.Chunk.fromArray(impl.cisRuleDetails().asByteArrayUnsafe())
      )
    override val ruleId: RuleId =
      zio.aws.inspector2.model.primitives.RuleId(impl.ruleId())
    override val status: zio.aws.inspector2.model.CisRuleStatus =
      zio.aws.inspector2.model.CisRuleStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisSessionMessage
  ): zio.aws.inspector2.model.CisSessionMessage.ReadOnly = new Wrapper(impl)
}
