package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisSortOrder {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisSortOrder
}
object CisSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisSortOrder
  ): zio.aws.inspector2.model.CisSortOrder = value match {
    case software.amazon.awssdk.services.inspector2.model.CisSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisSortOrder.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.inspector2.model.CisSortOrder.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSortOrder =
      software.amazon.awssdk.services.inspector2.model.CisSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.inspector2.model.CisSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSortOrder =
      software.amazon.awssdk.services.inspector2.model.CisSortOrder.ASC
  }
  case object DESC extends zio.aws.inspector2.model.CisSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisSortOrder =
      software.amazon.awssdk.services.inspector2.model.CisSortOrder.DESC
  }
}
