package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisStringComparison {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.CisStringComparison
}
object CisStringComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisStringComparison
  ): zio.aws.inspector2.model.CisStringComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.CisStringComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisStringComparison.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.inspector2.model.CisStringComparison.PREFIX =>
      val r = PREFIX
      r
    case software.amazon.awssdk.services.inspector2.model.CisStringComparison.NOT_EQUALS =>
      val r = NOT_EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisStringComparison =
      software.amazon.awssdk.services.inspector2.model.CisStringComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.inspector2.model.CisStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisStringComparison =
      software.amazon.awssdk.services.inspector2.model.CisStringComparison.EQUALS
  }
  case object PREFIX extends zio.aws.inspector2.model.CisStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisStringComparison =
      software.amazon.awssdk.services.inspector2.model.CisStringComparison.PREFIX
  }
  case object NOT_EQUALS extends zio.aws.inspector2.model.CisStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisStringComparison =
      software.amazon.awssdk.services.inspector2.model.CisStringComparison.NOT_EQUALS
  }
}
