package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CisStringFilter(
    comparison: zio.aws.inspector2.model.CisStringComparison,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisStringFilter = {
    import CisStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisStringFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisStringFilter.ReadOnly =
    zio.aws.inspector2.model.CisStringFilter.wrap(buildAwsValue())
}
object CisStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisStringFilter =
      zio.aws.inspector2.model.CisStringFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CisStringComparison
    def value: String
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CisStringComparison] =
      ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisStringFilter
  ) extends zio.aws.inspector2.model.CisStringFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.CisStringComparison =
      zio.aws.inspector2.model.CisStringComparison.wrap(impl.comparison())
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisStringFilter
  ): zio.aws.inspector2.model.CisStringFilter.ReadOnly = new Wrapper(impl)
}
