package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  TargetResourceTagsKey,
  AccountId,
  TargetResourceTagsValue,
  CisScanArn,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class CisTargetResourceAggregation(
    accountId: Optional[AccountId] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    scanArn: CisScanArn,
    statusCounts: Optional[zio.aws.inspector2.model.StatusCounts] =
      Optional.Absent,
    targetResourceId: Optional[ResourceId] = Optional.Absent,
    targetResourceTags: Optional[
      Map[TargetResourceTagsKey, Iterable[TargetResourceTagsValue]]
    ] = Optional.Absent,
    targetStatus: Optional[zio.aws.inspector2.model.CisTargetStatus] =
      Optional.Absent,
    targetStatusReason: Optional[
      zio.aws.inspector2.model.CisTargetStatusReason
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation = {
    import CisTargetResourceAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(statusCounts.map(value => value.buildAwsValue()))(
        _.statusCounts
      )
      .optionallyWith(
        targetResourceId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.targetResourceId)
      .optionallyWith(
        targetResourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TargetResourceTagsKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                TargetResourceTagsValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.targetResourceTags)
      .optionallyWith(targetStatus.map(value => value.unwrap))(_.targetStatus)
      .optionallyWith(targetStatusReason.map(value => value.unwrap))(
        _.targetStatusReason
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CisTargetResourceAggregation.ReadOnly =
    zio.aws.inspector2.model.CisTargetResourceAggregation.wrap(buildAwsValue())
}
object CisTargetResourceAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisTargetResourceAggregation =
      zio.aws.inspector2.model.CisTargetResourceAggregation(
        accountId.map(value => value),
        platform.map(value => value),
        scanArn,
        statusCounts.map(value => value.asEditable),
        targetResourceId.map(value => value),
        targetResourceTags.map(value => value),
        targetStatus.map(value => value),
        targetStatusReason.map(value => value)
      )
    def accountId: Optional[AccountId]
    def platform: Optional[String]
    def scanArn: CisScanArn
    def statusCounts: Optional[zio.aws.inspector2.model.StatusCounts.ReadOnly]
    def targetResourceId: Optional[ResourceId]
    def targetResourceTags
        : Optional[Map[TargetResourceTagsKey, List[TargetResourceTagsValue]]]
    def targetStatus: Optional[zio.aws.inspector2.model.CisTargetStatus]
    def targetStatusReason
        : Optional[zio.aws.inspector2.model.CisTargetStatusReason]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getStatusCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StatusCounts.ReadOnly] =
      AwsError.unwrapOptionField("statusCounts", statusCounts)
    def getTargetResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("targetResourceId", targetResourceId)
    def getTargetResourceTags
        : ZIO[Any, AwsError, Map[TargetResourceTagsKey, List[
          TargetResourceTagsValue
        ]]] =
      AwsError.unwrapOptionField("targetResourceTags", targetResourceTags)
    def getTargetStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisTargetStatus] =
      AwsError.unwrapOptionField("targetStatus", targetStatus)
    def getTargetStatusReason
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisTargetStatusReason] =
      AwsError.unwrapOptionField("targetStatusReason", targetStatusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation
  ) extends zio.aws.inspector2.model.CisTargetResourceAggregation.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val statusCounts
        : Optional[zio.aws.inspector2.model.StatusCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCounts())
        .map(value => zio.aws.inspector2.model.StatusCounts.wrap(value))
    override val targetResourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetResourceId())
      .map(value => zio.aws.inspector2.model.primitives.ResourceId(value))
    override val targetResourceTags
        : Optional[Map[TargetResourceTagsKey, List[TargetResourceTagsValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.inspector2.model.primitives
                .TargetResourceTagsKey(key) -> value.asScala.map { item =>
                zio.aws.inspector2.model.primitives
                  .TargetResourceTagsValue(item)
              }.toList
            })
            .toMap
        )
    override val targetStatus
        : Optional[zio.aws.inspector2.model.CisTargetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetStatus())
        .map(value => zio.aws.inspector2.model.CisTargetStatus.wrap(value))
    override val targetStatusReason
        : Optional[zio.aws.inspector2.model.CisTargetStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetStatusReason())
        .map(value =>
          zio.aws.inspector2.model.CisTargetStatusReason.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation
  ): zio.aws.inspector2.model.CisTargetResourceAggregation.ReadOnly =
    new Wrapper(impl)
}
