package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisTargetStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CisTargetStatus
}
object CisTargetStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisTargetStatus
  ): zio.aws.inspector2.model.CisTargetStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisTargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatus =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object TIMED_OUT extends zio.aws.inspector2.model.CisTargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatus =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatus.TIMED_OUT
  }
  case object CANCELLED extends zio.aws.inspector2.model.CisTargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatus =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatus.CANCELLED
  }
  case object COMPLETED extends zio.aws.inspector2.model.CisTargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatus =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatus.COMPLETED
  }
}
