package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CisTargetStatusFilter(
    comparison: zio.aws.inspector2.model.CisTargetStatusComparison,
    value: zio.aws.inspector2.model.CisTargetStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter = {
    import CisTargetStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisTargetStatusFilter.ReadOnly =
    zio.aws.inspector2.model.CisTargetStatusFilter.wrap(buildAwsValue())
}
object CisTargetStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisTargetStatusFilter =
      zio.aws.inspector2.model.CisTargetStatusFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CisTargetStatusComparison
    def value: zio.aws.inspector2.model.CisTargetStatus
    def getComparison: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.CisTargetStatusComparison
    ] = ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, zio.aws.inspector2.model.CisTargetStatus] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter
  ) extends zio.aws.inspector2.model.CisTargetStatusFilter.ReadOnly {
    override val comparison
        : zio.aws.inspector2.model.CisTargetStatusComparison =
      zio.aws.inspector2.model.CisTargetStatusComparison.wrap(impl.comparison())
    override val value: zio.aws.inspector2.model.CisTargetStatus =
      zio.aws.inspector2.model.CisTargetStatus.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter
  ): zio.aws.inspector2.model.CisTargetStatusFilter.ReadOnly = new Wrapper(impl)
}
