package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CisTargetStatusReason {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason
}
object CisTargetStatusReason {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason
  ): zio.aws.inspector2.model.CisTargetStatusReason = value match {
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.SCAN_IN_PROGRESS =>
      val r = SCAN_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.UNSUPPORTED_OS =>
      val r = UNSUPPORTED_OS
      r
    case software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.SSM_UNMANAGED =>
      val r = SSM_UNMANAGED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CisTargetStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.UNKNOWN_TO_SDK_VERSION
  }
  case object SCAN_IN_PROGRESS
      extends zio.aws.inspector2.model.CisTargetStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.SCAN_IN_PROGRESS
  }
  case object UNSUPPORTED_OS
      extends zio.aws.inspector2.model.CisTargetStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.UNSUPPORTED_OS
  }
  case object SSM_UNMANAGED
      extends zio.aws.inspector2.model.CisTargetStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason =
      software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason.SSM_UNMANAGED
  }
}
