package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{NonEmptyString, Integer}
import scala.jdk.CollectionConverters.*
final case class CodeFilePath(
    endLine: Integer,
    fileName: NonEmptyString,
    filePath: NonEmptyString,
    startLine: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CodeFilePath = {
    import CodeFilePath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CodeFilePath
      .builder()
      .endLine(endLine: java.lang.Integer)
      .fileName(NonEmptyString.unwrap(fileName): java.lang.String)
      .filePath(NonEmptyString.unwrap(filePath): java.lang.String)
      .startLine(startLine: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CodeFilePath.ReadOnly =
    zio.aws.inspector2.model.CodeFilePath.wrap(buildAwsValue())
}
object CodeFilePath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CodeFilePath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CodeFilePath =
      zio.aws.inspector2.model.CodeFilePath(
        endLine,
        fileName,
        filePath,
        startLine
      )
    def endLine: Integer
    def fileName: NonEmptyString
    def filePath: NonEmptyString
    def startLine: Integer
    def getEndLine: ZIO[Any, Nothing, Integer] = ZIO.succeed(endLine)
    def getFileName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(fileName)
    def getFilePath: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(filePath)
    def getStartLine: ZIO[Any, Nothing, Integer] = ZIO.succeed(startLine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CodeFilePath
  ) extends zio.aws.inspector2.model.CodeFilePath.ReadOnly {
    override val endLine: Integer = impl.endLine(): Integer
    override val fileName: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.fileName())
    override val filePath: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.filePath())
    override val startLine: Integer = impl.startLine(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CodeFilePath
  ): zio.aws.inspector2.model.CodeFilePath.ReadOnly = new Wrapper(impl)
}
