package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{Integer, CodeLineContentString}
import scala.jdk.CollectionConverters.*
final case class CodeLine(content: CodeLineContentString, lineNumber: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CodeLine = {
    import CodeLine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CodeLine
      .builder()
      .content(CodeLineContentString.unwrap(content): java.lang.String)
      .lineNumber(lineNumber: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CodeLine.ReadOnly =
    zio.aws.inspector2.model.CodeLine.wrap(buildAwsValue())
}
object CodeLine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CodeLine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CodeLine =
      zio.aws.inspector2.model.CodeLine(content, lineNumber)
    def content: CodeLineContentString
    def lineNumber: Integer
    def getContent: ZIO[Any, Nothing, CodeLineContentString] =
      ZIO.succeed(content)
    def getLineNumber: ZIO[Any, Nothing, Integer] = ZIO.succeed(lineNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CodeLine
  ) extends zio.aws.inspector2.model.CodeLine.ReadOnly {
    override val content: CodeLineContentString =
      zio.aws.inspector2.model.primitives.CodeLineContentString(impl.content())
    override val lineNumber: Integer = impl.lineNumber(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CodeLine
  ): zio.aws.inspector2.model.CodeLine.ReadOnly = new Wrapper(impl)
}
