package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{FindingArn, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class CodeSnippetError(
    errorCode: zio.aws.inspector2.model.CodeSnippetErrorCode,
    errorMessage: NonEmptyString,
    findingArn: FindingArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CodeSnippetError = {
    import CodeSnippetError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CodeSnippetError
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .findingArn(FindingArn.unwrap(findingArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CodeSnippetError.ReadOnly =
    zio.aws.inspector2.model.CodeSnippetError.wrap(buildAwsValue())
}
object CodeSnippetError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CodeSnippetError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CodeSnippetError =
      zio.aws.inspector2.model
        .CodeSnippetError(errorCode, errorMessage, findingArn)
    def errorCode: zio.aws.inspector2.model.CodeSnippetErrorCode
    def errorMessage: NonEmptyString
    def findingArn: FindingArn
    def getErrorCode
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CodeSnippetErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
    def getFindingArn: ZIO[Any, Nothing, FindingArn] = ZIO.succeed(findingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CodeSnippetError
  ) extends zio.aws.inspector2.model.CodeSnippetError.ReadOnly {
    override val errorCode: zio.aws.inspector2.model.CodeSnippetErrorCode =
      zio.aws.inspector2.model.CodeSnippetErrorCode.wrap(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.errorMessage())
    override val findingArn: FindingArn =
      zio.aws.inspector2.model.primitives.FindingArn(impl.findingArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CodeSnippetError
  ): zio.aws.inspector2.model.CodeSnippetError.ReadOnly = new Wrapper(impl)
}
