package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait CodeSnippetErrorCode {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode
}
object CodeSnippetErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode
  ): zio.aws.inspector2.model.CodeSnippetErrorCode = value match {
    case software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.CODE_SNIPPET_NOT_FOUND =>
      val r = CODE_SNIPPET_NOT_FOUND
      r
    case software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.INVALID_INPUT =>
      val r = INVALID_INPUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CodeSnippetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode =
      software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.inspector2.model.CodeSnippetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode =
      software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.INTERNAL_ERROR
  }
  case object ACCESS_DENIED
      extends zio.aws.inspector2.model.CodeSnippetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode =
      software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.ACCESS_DENIED
  }
  case object CODE_SNIPPET_NOT_FOUND
      extends zio.aws.inspector2.model.CodeSnippetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode =
      software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.CODE_SNIPPET_NOT_FOUND
  }
  case object INVALID_INPUT
      extends zio.aws.inspector2.model.CodeSnippetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode =
      software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorCode.INVALID_INPUT
  }
}
