package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{FindingArn, Integer}
import scala.jdk.CollectionConverters.*
final case class CodeSnippetResult(
    codeSnippet: Optional[Iterable[zio.aws.inspector2.model.CodeLine]] =
      Optional.Absent,
    endLine: Optional[Integer] = Optional.Absent,
    findingArn: Optional[FindingArn] = Optional.Absent,
    startLine: Optional[Integer] = Optional.Absent,
    suggestedFixes: Optional[Iterable[zio.aws.inspector2.model.SuggestedFix]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CodeSnippetResult = {
    import CodeSnippetResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CodeSnippetResult
      .builder()
      .optionallyWith(
        codeSnippet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeSnippet)
      .optionallyWith(endLine.map(value => value: java.lang.Integer))(_.endLine)
      .optionallyWith(
        findingArn.map(value => FindingArn.unwrap(value): java.lang.String)
      )(_.findingArn)
      .optionallyWith(startLine.map(value => value: java.lang.Integer))(
        _.startLine
      )
      .optionallyWith(
        suggestedFixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suggestedFixes)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CodeSnippetResult.ReadOnly =
    zio.aws.inspector2.model.CodeSnippetResult.wrap(buildAwsValue())
}
object CodeSnippetResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CodeSnippetResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CodeSnippetResult =
      zio.aws.inspector2.model.CodeSnippetResult(
        codeSnippet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endLine.map(value => value),
        findingArn.map(value => value),
        startLine.map(value => value),
        suggestedFixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def codeSnippet: Optional[List[zio.aws.inspector2.model.CodeLine.ReadOnly]]
    def endLine: Optional[Integer]
    def findingArn: Optional[FindingArn]
    def startLine: Optional[Integer]
    def suggestedFixes
        : Optional[List[zio.aws.inspector2.model.SuggestedFix.ReadOnly]]
    def getCodeSnippet
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.CodeLine.ReadOnly]] =
      AwsError.unwrapOptionField("codeSnippet", codeSnippet)
    def getEndLine: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endLine", endLine)
    def getFindingArn: ZIO[Any, AwsError, FindingArn] =
      AwsError.unwrapOptionField("findingArn", findingArn)
    def getStartLine: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startLine", startLine)
    def getSuggestedFixes: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.SuggestedFix.ReadOnly
    ]] = AwsError.unwrapOptionField("suggestedFixes", suggestedFixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CodeSnippetResult
  ) extends zio.aws.inspector2.model.CodeSnippetResult.ReadOnly {
    override val codeSnippet
        : Optional[List[zio.aws.inspector2.model.CodeLine.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSnippet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CodeLine.wrap(item)
          }.toList
        )
    override val endLine: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endLine())
      .map(value => value: Integer)
    override val findingArn: Optional[FindingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.findingArn())
      .map(value => zio.aws.inspector2.model.primitives.FindingArn(value))
    override val startLine: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.startLine())
      .map(value => value: Integer)
    override val suggestedFixes
        : Optional[List[zio.aws.inspector2.model.SuggestedFix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestedFixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.SuggestedFix.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CodeSnippetResult
  ): zio.aws.inspector2.model.CodeSnippetResult.ReadOnly = new Wrapper(impl)
}
