package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{LambdaLayerArn, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class CodeVulnerabilityDetails(
    cwes: Iterable[NonEmptyString],
    detectorId: NonEmptyString,
    detectorName: NonEmptyString,
    detectorTags: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    filePath: zio.aws.inspector2.model.CodeFilePath,
    referenceUrls: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    ruleId: Optional[NonEmptyString] = Optional.Absent,
    sourceLambdaLayerArn: Optional[LambdaLayerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CodeVulnerabilityDetails = {
    import CodeVulnerabilityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CodeVulnerabilityDetails
      .builder()
      .cwes(cwes.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .detectorId(NonEmptyString.unwrap(detectorId): java.lang.String)
      .detectorName(NonEmptyString.unwrap(detectorName): java.lang.String)
      .optionallyWith(
        detectorTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.detectorTags)
      .filePath(filePath.buildAwsValue())
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        sourceLambdaLayerArn.map(value =>
          LambdaLayerArn.unwrap(value): java.lang.String
        )
      )(_.sourceLambdaLayerArn)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CodeVulnerabilityDetails.ReadOnly =
    zio.aws.inspector2.model.CodeVulnerabilityDetails.wrap(buildAwsValue())
}
object CodeVulnerabilityDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CodeVulnerabilityDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CodeVulnerabilityDetails =
      zio.aws.inspector2.model.CodeVulnerabilityDetails(
        cwes,
        detectorId,
        detectorName,
        detectorTags.map(value => value),
        filePath.asEditable,
        referenceUrls.map(value => value),
        ruleId.map(value => value),
        sourceLambdaLayerArn.map(value => value)
      )
    def cwes: List[NonEmptyString]
    def detectorId: NonEmptyString
    def detectorName: NonEmptyString
    def detectorTags: Optional[List[NonEmptyString]]
    def filePath: zio.aws.inspector2.model.CodeFilePath.ReadOnly
    def referenceUrls: Optional[List[NonEmptyString]]
    def ruleId: Optional[NonEmptyString]
    def sourceLambdaLayerArn: Optional[LambdaLayerArn]
    def getCwes: ZIO[Any, Nothing, List[NonEmptyString]] = ZIO.succeed(cwes)
    def getDetectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(detectorId)
    def getDetectorName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(detectorName)
    def getDetectorTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("detectorTags", detectorTags)
    def getFilePath
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CodeFilePath.ReadOnly] =
      ZIO.succeed(filePath)
    def getReferenceUrls: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getSourceLambdaLayerArn: ZIO[Any, AwsError, LambdaLayerArn] =
      AwsError.unwrapOptionField("sourceLambdaLayerArn", sourceLambdaLayerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CodeVulnerabilityDetails
  ) extends zio.aws.inspector2.model.CodeVulnerabilityDetails.ReadOnly {
    override val cwes: List[NonEmptyString] = impl
      .cwes()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.NonEmptyString(item)
      }
      .toList
    override val detectorId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.detectorId())
    override val detectorName: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.detectorName())
    override val detectorTags: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectorTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val filePath: zio.aws.inspector2.model.CodeFilePath.ReadOnly =
      zio.aws.inspector2.model.CodeFilePath.wrap(impl.filePath())
    override val referenceUrls: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceUrls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val ruleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val sourceLambdaLayerArn: Optional[LambdaLayerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLambdaLayerArn())
        .map(value => zio.aws.inspector2.model.primitives.LambdaLayerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CodeVulnerabilityDetails
  ): zio.aws.inspector2.model.CodeVulnerabilityDetails.ReadOnly = new Wrapper(
    impl
  )
}
