package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{PlatformVersion, Vendor}
import scala.jdk.CollectionConverters.*
final case class ComputePlatform(
    product: Optional[zio.aws.inspector2.model.primitives.Product] =
      Optional.Absent,
    vendor: Optional[Vendor] = Optional.Absent,
    version: Optional[PlatformVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ComputePlatform = {
    import ComputePlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ComputePlatform
      .builder()
      .optionallyWith(
        product.map(value =>
          zio.aws.inspector2.model.primitives.Product
            .unwrap(value): java.lang.String
        )
      )(_.product)
      .optionallyWith(
        vendor.map(value => Vendor.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        version.map(value => PlatformVersion.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ComputePlatform.ReadOnly =
    zio.aws.inspector2.model.ComputePlatform.wrap(buildAwsValue())
}
object ComputePlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ComputePlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ComputePlatform =
      zio.aws.inspector2.model.ComputePlatform(
        product.map(value => value),
        vendor.map(value => value),
        version.map(value => value)
      )
    def product: Optional[zio.aws.inspector2.model.primitives.Product]
    def vendor: Optional[Vendor]
    def version: Optional[PlatformVersion]
    def getProduct
        : ZIO[Any, AwsError, zio.aws.inspector2.model.primitives.Product] =
      AwsError.unwrapOptionField("product", product)
    def getVendor: ZIO[Any, AwsError, Vendor] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getVersion: ZIO[Any, AwsError, PlatformVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ComputePlatform
  ) extends zio.aws.inspector2.model.ComputePlatform.ReadOnly {
    override val product
        : Optional[zio.aws.inspector2.model.primitives.Product] =
      zio.aws.core.internal
        .optionalFromNullable(impl.product())
        .map(value => zio.aws.inspector2.model.primitives.Product(value))
    override val vendor: Optional[Vendor] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value => zio.aws.inspector2.model.primitives.Vendor(value))
    override val version: Optional[PlatformVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.inspector2.model.primitives.PlatformVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ComputePlatform
  ): zio.aws.inspector2.model.ComputePlatform.ReadOnly = new Wrapper(impl)
}
