package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.DateTimeTimestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CoverageDateFilter(
    endInclusive: Optional[DateTimeTimestamp] = Optional.Absent,
    startInclusive: Optional[DateTimeTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoverageDateFilter = {
    import CoverageDateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoverageDateFilter
      .builder()
      .optionallyWith(
        endInclusive.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.endInclusive)
      .optionallyWith(
        startInclusive.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.startInclusive)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoverageDateFilter.ReadOnly =
    zio.aws.inspector2.model.CoverageDateFilter.wrap(buildAwsValue())
}
object CoverageDateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoverageDateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoverageDateFilter =
      zio.aws.inspector2.model.CoverageDateFilter(
        endInclusive.map(value => value),
        startInclusive.map(value => value)
      )
    def endInclusive: Optional[DateTimeTimestamp]
    def startInclusive: Optional[DateTimeTimestamp]
    def getEndInclusive: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("endInclusive", endInclusive)
    def getStartInclusive: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("startInclusive", startInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageDateFilter
  ) extends zio.aws.inspector2.model.CoverageDateFilter.ReadOnly {
    override val endInclusive: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endInclusive())
        .map(value =>
          zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
        )
    override val startInclusive: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startInclusive())
        .map(value =>
          zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageDateFilter
  ): zio.aws.inspector2.model.CoverageDateFilter.ReadOnly = new Wrapper(impl)
}
