package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.CoverageStringInput
import scala.jdk.CollectionConverters.*
final case class CoverageStringFilter(
    comparison: zio.aws.inspector2.model.CoverageStringComparison,
    value: CoverageStringInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoverageStringFilter = {
    import CoverageStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoverageStringFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(CoverageStringInput.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoverageStringFilter.ReadOnly =
    zio.aws.inspector2.model.CoverageStringFilter.wrap(buildAwsValue())
}
object CoverageStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoverageStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoverageStringFilter =
      zio.aws.inspector2.model.CoverageStringFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.CoverageStringComparison
    def value: CoverageStringInput
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CoverageStringComparison] =
      ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, CoverageStringInput] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageStringFilter
  ) extends zio.aws.inspector2.model.CoverageStringFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.CoverageStringComparison =
      zio.aws.inspector2.model.CoverageStringComparison.wrap(impl.comparison())
    override val value: CoverageStringInput =
      zio.aws.inspector2.model.primitives.CoverageStringInput(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageStringFilter
  ): zio.aws.inspector2.model.CoverageStringFilter.ReadOnly = new Wrapper(impl)
}
