package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  ResourceId,
  DateTimeTimestamp,
  AccountId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CoveredResource(
    accountId: AccountId,
    lastScannedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    resourceId: ResourceId,
    resourceMetadata: Optional[zio.aws.inspector2.model.ResourceScanMetadata] =
      Optional.Absent,
    resourceType: zio.aws.inspector2.model.CoverageResourceType,
    scanMode: Optional[zio.aws.inspector2.model.ScanMode] = Optional.Absent,
    scanStatus: Optional[zio.aws.inspector2.model.ScanStatus] = Optional.Absent,
    scanType: zio.aws.inspector2.model.ScanType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoveredResource = {
    import CoveredResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoveredResource
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        lastScannedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.lastScannedAt)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(resourceMetadata.map(value => value.buildAwsValue()))(
        _.resourceMetadata
      )
      .resourceType(resourceType.unwrap)
      .optionallyWith(scanMode.map(value => value.unwrap))(_.scanMode)
      .optionallyWith(scanStatus.map(value => value.buildAwsValue()))(
        _.scanStatus
      )
      .scanType(scanType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoveredResource.ReadOnly =
    zio.aws.inspector2.model.CoveredResource.wrap(buildAwsValue())
}
object CoveredResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoveredResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoveredResource =
      zio.aws.inspector2.model.CoveredResource(
        accountId,
        lastScannedAt.map(value => value),
        resourceId,
        resourceMetadata.map(value => value.asEditable),
        resourceType,
        scanMode.map(value => value),
        scanStatus.map(value => value.asEditable),
        scanType
      )
    def accountId: AccountId
    def lastScannedAt: Optional[DateTimeTimestamp]
    def resourceId: ResourceId
    def resourceMetadata
        : Optional[zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly]
    def resourceType: zio.aws.inspector2.model.CoverageResourceType
    def scanMode: Optional[zio.aws.inspector2.model.ScanMode]
    def scanStatus: Optional[zio.aws.inspector2.model.ScanStatus.ReadOnly]
    def scanType: zio.aws.inspector2.model.ScanType
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getLastScannedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("lastScannedAt", lastScannedAt)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getResourceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("resourceMetadata", resourceMetadata)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CoverageResourceType] =
      ZIO.succeed(resourceType)
    def getScanMode: ZIO[Any, AwsError, zio.aws.inspector2.model.ScanMode] =
      AwsError.unwrapOptionField("scanMode", scanMode)
    def getScanStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ScanStatus.ReadOnly] =
      AwsError.unwrapOptionField("scanStatus", scanStatus)
    def getScanType: ZIO[Any, Nothing, zio.aws.inspector2.model.ScanType] =
      ZIO.succeed(scanType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoveredResource
  ) extends zio.aws.inspector2.model.CoveredResource.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val lastScannedAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastScannedAt())
        .map(value =>
          zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
        )
    override val resourceId: ResourceId =
      zio.aws.inspector2.model.primitives.ResourceId(impl.resourceId())
    override val resourceMetadata
        : Optional[zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceMetadata())
        .map(value => zio.aws.inspector2.model.ResourceScanMetadata.wrap(value))
    override val resourceType: zio.aws.inspector2.model.CoverageResourceType =
      zio.aws.inspector2.model.CoverageResourceType.wrap(impl.resourceType())
    override val scanMode: Optional[zio.aws.inspector2.model.ScanMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanMode())
        .map(value => zio.aws.inspector2.model.ScanMode.wrap(value))
    override val scanStatus
        : Optional[zio.aws.inspector2.model.ScanStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanStatus())
        .map(value => zio.aws.inspector2.model.ScanStatus.wrap(value))
    override val scanType: zio.aws.inspector2.model.ScanType =
      zio.aws.inspector2.model.ScanType.wrap(impl.scanType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoveredResource
  ): zio.aws.inspector2.model.CoveredResource.ReadOnly = new Wrapper(impl)
}
