package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{MapValue, MapKey, CisScanName}
import scala.jdk.CollectionConverters.*
final case class CreateCisScanConfigurationRequest(
    scanName: CisScanName,
    schedule: zio.aws.inspector2.model.Schedule,
    securityLevel: zio.aws.inspector2.model.CisSecurityLevel,
    tags: Optional[Map[MapKey, MapValue]] = Optional.Absent,
    targets: zio.aws.inspector2.model.CreateCisTargets
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest = {
    import CreateCisScanConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest
      .builder()
      .scanName(CisScanName.unwrap(scanName): java.lang.String)
      .schedule(schedule.buildAwsValue())
      .securityLevel(securityLevel.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .targets(targets.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CreateCisScanConfigurationRequest.ReadOnly =
    zio.aws.inspector2.model.CreateCisScanConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateCisScanConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateCisScanConfigurationRequest =
      zio.aws.inspector2.model.CreateCisScanConfigurationRequest(
        scanName,
        schedule.asEditable,
        securityLevel,
        tags.map(value => value),
        targets.asEditable
      )
    def scanName: CisScanName
    def schedule: zio.aws.inspector2.model.Schedule.ReadOnly
    def securityLevel: zio.aws.inspector2.model.CisSecurityLevel
    def tags: Optional[Map[MapKey, MapValue]]
    def targets: zio.aws.inspector2.model.CreateCisTargets.ReadOnly
    def getScanName: ZIO[Any, Nothing, CisScanName] = ZIO.succeed(scanName)
    def getSchedule
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Schedule.ReadOnly] =
      ZIO.succeed(schedule)
    def getSecurityLevel
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CisSecurityLevel] =
      ZIO.succeed(securityLevel)
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargets: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.CreateCisTargets.ReadOnly
    ] = ZIO.succeed(targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest
  ) extends zio.aws.inspector2.model.CreateCisScanConfigurationRequest.ReadOnly {
    override val scanName: CisScanName =
      zio.aws.inspector2.model.primitives.CisScanName(impl.scanName())
    override val schedule: zio.aws.inspector2.model.Schedule.ReadOnly =
      zio.aws.inspector2.model.Schedule.wrap(impl.schedule())
    override val securityLevel: zio.aws.inspector2.model.CisSecurityLevel =
      zio.aws.inspector2.model.CisSecurityLevel.wrap(impl.securityLevel())
    override val tags: Optional[Map[MapKey, MapValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
    override val targets: zio.aws.inspector2.model.CreateCisTargets.ReadOnly =
      zio.aws.inspector2.model.CreateCisTargets.wrap(impl.targets())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest
  ): zio.aws.inspector2.model.CreateCisScanConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
