package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.CisScanConfigurationArn
import scala.jdk.CollectionConverters.*
final case class CreateCisScanConfigurationResponse(
    scanConfigurationArn: Optional[CisScanConfigurationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse = {
    import CreateCisScanConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse
      .builder()
      .optionallyWith(
        scanConfigurationArn.map(value =>
          CisScanConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.scanConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CreateCisScanConfigurationResponse.ReadOnly =
    zio.aws.inspector2.model.CreateCisScanConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateCisScanConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.CreateCisScanConfigurationResponse =
      zio.aws.inspector2.model.CreateCisScanConfigurationResponse(
        scanConfigurationArn.map(value => value)
      )
    def scanConfigurationArn: Optional[CisScanConfigurationArn]
    def getScanConfigurationArn: ZIO[Any, AwsError, CisScanConfigurationArn] =
      AwsError.unwrapOptionField("scanConfigurationArn", scanConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse
  ) extends zio.aws.inspector2.model.CreateCisScanConfigurationResponse.ReadOnly {
    override val scanConfigurationArn: Optional[CisScanConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanConfigurationArn())
        .map(value =>
          zio.aws.inspector2.model.primitives.CisScanConfigurationArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse
  ): zio.aws.inspector2.model.CreateCisScanConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
