package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{
  TargetResourceTagsValue,
  TargetResourceTagsKey,
  TargetAccount
}
import scala.jdk.CollectionConverters.*
final case class CreateCisTargets(
    accountIds: Iterable[TargetAccount],
    targetResourceTags: Map[TargetResourceTagsKey, Iterable[
      TargetResourceTagsValue
    ]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateCisTargets = {
    import CreateCisTargets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateCisTargets
      .builder()
      .accountIds(accountIds.map { item =>
        TargetAccount.unwrap(item): java.lang.String
      }.asJavaCollection)
      .targetResourceTags(
        targetResourceTags
          .map({ case (key, value) =>
            (TargetResourceTagsKey.unwrap(key): java.lang.String) -> value.map {
              item =>
                TargetResourceTagsValue.unwrap(item): java.lang.String
            }.asJavaCollection
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CreateCisTargets.ReadOnly =
    zio.aws.inspector2.model.CreateCisTargets.wrap(buildAwsValue())
}
object CreateCisTargets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateCisTargets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateCisTargets =
      zio.aws.inspector2.model.CreateCisTargets(accountIds, targetResourceTags)
    def accountIds: List[TargetAccount]
    def targetResourceTags
        : Map[TargetResourceTagsKey, List[TargetResourceTagsValue]]
    def getAccountIds: ZIO[Any, Nothing, List[TargetAccount]] =
      ZIO.succeed(accountIds)
    def getTargetResourceTags
        : ZIO[Any, Nothing, Map[TargetResourceTagsKey, List[
          TargetResourceTagsValue
        ]]] = ZIO.succeed(targetResourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateCisTargets
  ) extends zio.aws.inspector2.model.CreateCisTargets.ReadOnly {
    override val accountIds: List[TargetAccount] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.TargetAccount(item)
      }
      .toList
    override val targetResourceTags
        : Map[TargetResourceTagsKey, List[TargetResourceTagsValue]] = impl
      .targetResourceTags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector2.model.primitives
          .TargetResourceTagsKey(key) -> value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.TargetResourceTagsValue(item)
        }.toList
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateCisTargets
  ): zio.aws.inspector2.model.CreateCisTargets.ReadOnly = new Wrapper(impl)
}
