package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.FilterArn
import scala.jdk.CollectionConverters.*
final case class CreateFilterResponse(arn: FilterArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateFilterResponse = {
    import CreateFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateFilterResponse
      .builder()
      .arn(FilterArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CreateFilterResponse.ReadOnly =
    zio.aws.inspector2.model.CreateFilterResponse.wrap(buildAwsValue())
}
object CreateFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateFilterResponse =
      zio.aws.inspector2.model.CreateFilterResponse(arn)
    def arn: FilterArn
    def getArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateFilterResponse
  ) extends zio.aws.inspector2.model.CreateFilterResponse.ReadOnly {
    override val arn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateFilterResponse
  ): zio.aws.inspector2.model.CreateFilterResponse.ReadOnly = new Wrapper(impl)
}
