package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSbomExportRequest(
    reportFormat: zio.aws.inspector2.model.SbomReportFormat,
    resourceFilterCriteria: Optional[
      zio.aws.inspector2.model.ResourceFilterCriteria
    ] = Optional.Absent,
    s3Destination: zio.aws.inspector2.model.Destination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest = {
    import CreateSbomExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest
      .builder()
      .reportFormat(reportFormat.unwrap)
      .optionallyWith(
        resourceFilterCriteria.map(value => value.buildAwsValue())
      )(_.resourceFilterCriteria)
      .s3Destination(s3Destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CreateSbomExportRequest.ReadOnly =
    zio.aws.inspector2.model.CreateSbomExportRequest.wrap(buildAwsValue())
}
object CreateSbomExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateSbomExportRequest =
      zio.aws.inspector2.model.CreateSbomExportRequest(
        reportFormat,
        resourceFilterCriteria.map(value => value.asEditable),
        s3Destination.asEditable
      )
    def reportFormat: zio.aws.inspector2.model.SbomReportFormat
    def resourceFilterCriteria
        : Optional[zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly]
    def s3Destination: zio.aws.inspector2.model.Destination.ReadOnly
    def getReportFormat
        : ZIO[Any, Nothing, zio.aws.inspector2.model.SbomReportFormat] =
      ZIO.succeed(reportFormat)
    def getResourceFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceFilterCriteria",
      resourceFilterCriteria
    )
    def getS3Destination
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Destination.ReadOnly] =
      ZIO.succeed(s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest
  ) extends zio.aws.inspector2.model.CreateSbomExportRequest.ReadOnly {
    override val reportFormat: zio.aws.inspector2.model.SbomReportFormat =
      zio.aws.inspector2.model.SbomReportFormat.wrap(impl.reportFormat())
    override val resourceFilterCriteria
        : Optional[zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceFilterCriteria())
        .map(value =>
          zio.aws.inspector2.model.ResourceFilterCriteria.wrap(value)
        )
    override val s3Destination: zio.aws.inspector2.model.Destination.ReadOnly =
      zio.aws.inspector2.model.Destination.wrap(impl.s3Destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest
  ): zio.aws.inspector2.model.CreateSbomExportRequest.ReadOnly = new Wrapper(
    impl
  )
}
