package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters.*
final case class CreateSbomExportResponse(
    reportId: Optional[ReportId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse = {
    import CreateSbomExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CreateSbomExportResponse.ReadOnly =
    zio.aws.inspector2.model.CreateSbomExportResponse.wrap(buildAwsValue())
}
object CreateSbomExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateSbomExportResponse =
      zio.aws.inspector2.model
        .CreateSbomExportResponse(reportId.map(value => value))
    def reportId: Optional[ReportId]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse
  ) extends zio.aws.inspector2.model.CreateSbomExportResponse.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value => zio.aws.inspector2.model.primitives.ReportId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse
  ): zio.aws.inspector2.model.CreateSbomExportResponse.ReadOnly = new Wrapper(
    impl
  )
}
