package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{Cvss3ScoringVector, Cvss3BaseScore}
import scala.jdk.CollectionConverters.*
final case class Cvss3(
    baseScore: Optional[Cvss3BaseScore] = Optional.Absent,
    scoringVector: Optional[Cvss3ScoringVector] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Cvss3 = {
    import Cvss3.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Cvss3
      .builder()
      .optionallyWith(
        baseScore.map(value => Cvss3BaseScore.unwrap(value): java.lang.Double)
      )(_.baseScore)
      .optionallyWith(
        scoringVector.map(value =>
          Cvss3ScoringVector.unwrap(value): java.lang.String
        )
      )(_.scoringVector)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Cvss3.ReadOnly =
    zio.aws.inspector2.model.Cvss3.wrap(buildAwsValue())
}
object Cvss3 {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Cvss3] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Cvss3 = zio.aws.inspector2.model
      .Cvss3(baseScore.map(value => value), scoringVector.map(value => value))
    def baseScore: Optional[Cvss3BaseScore]
    def scoringVector: Optional[Cvss3ScoringVector]
    def getBaseScore: ZIO[Any, AwsError, Cvss3BaseScore] =
      AwsError.unwrapOptionField("baseScore", baseScore)
    def getScoringVector: ZIO[Any, AwsError, Cvss3ScoringVector] =
      AwsError.unwrapOptionField("scoringVector", scoringVector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Cvss3
  ) extends zio.aws.inspector2.model.Cvss3.ReadOnly {
    override val baseScore: Optional[Cvss3BaseScore] = zio.aws.core.internal
      .optionalFromNullable(impl.baseScore())
      .map(value => zio.aws.inspector2.model.primitives.Cvss3BaseScore(value))
    override val scoringVector: Optional[Cvss3ScoringVector] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoringVector())
        .map(value =>
          zio.aws.inspector2.model.primitives.Cvss3ScoringVector(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Cvss3
  ): zio.aws.inspector2.model.Cvss3.ReadOnly = new Wrapper(impl)
}
