package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class CvssScoreAdjustment(
    metric: NonEmptyString,
    reason: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CvssScoreAdjustment = {
    import CvssScoreAdjustment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CvssScoreAdjustment
      .builder()
      .metric(NonEmptyString.unwrap(metric): java.lang.String)
      .reason(NonEmptyString.unwrap(reason): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CvssScoreAdjustment.ReadOnly =
    zio.aws.inspector2.model.CvssScoreAdjustment.wrap(buildAwsValue())
}
object CvssScoreAdjustment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CvssScoreAdjustment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CvssScoreAdjustment =
      zio.aws.inspector2.model.CvssScoreAdjustment(metric, reason)
    def metric: NonEmptyString
    def reason: NonEmptyString
    def getMetric: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(metric)
    def getReason: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CvssScoreAdjustment
  ) extends zio.aws.inspector2.model.CvssScoreAdjustment.ReadOnly {
    override val metric: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.metric())
    override val reason: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.reason())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CvssScoreAdjustment
  ): zio.aws.inspector2.model.CvssScoreAdjustment.ReadOnly = new Wrapper(impl)
}
