package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DailySchedule(startTime: zio.aws.inspector2.model.Time) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DailySchedule = {
    import DailySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DailySchedule
      .builder()
      .startTime(startTime.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DailySchedule.ReadOnly =
    zio.aws.inspector2.model.DailySchedule.wrap(buildAwsValue())
}
object DailySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DailySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DailySchedule =
      zio.aws.inspector2.model.DailySchedule(startTime.asEditable)
    def startTime: zio.aws.inspector2.model.Time.ReadOnly
    def getStartTime
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Time.ReadOnly] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DailySchedule
  ) extends zio.aws.inspector2.model.DailySchedule.ReadOnly {
    override val startTime: zio.aws.inspector2.model.Time.ReadOnly =
      zio.aws.inspector2.model.Time.wrap(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DailySchedule
  ): zio.aws.inspector2.model.DailySchedule.ReadOnly = new Wrapper(impl)
}
