package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DateFilter(
    endInclusive: Optional[Timestamp] = Optional.Absent,
    startInclusive: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DateFilter = {
    import DateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DateFilter
      .builder()
      .optionallyWith(
        endInclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.endInclusive)
      .optionallyWith(
        startInclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.startInclusive)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DateFilter.ReadOnly =
    zio.aws.inspector2.model.DateFilter.wrap(buildAwsValue())
}
object DateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DateFilter =
      zio.aws.inspector2.model.DateFilter(
        endInclusive.map(value => value),
        startInclusive.map(value => value)
      )
    def endInclusive: Optional[Timestamp]
    def startInclusive: Optional[Timestamp]
    def getEndInclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endInclusive", endInclusive)
    def getStartInclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startInclusive", startInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DateFilter
  ) extends zio.aws.inspector2.model.DateFilter.ReadOnly {
    override val endInclusive: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
    override val startInclusive: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DateFilter
  ): zio.aws.inspector2.model.DateFilter.ReadOnly = new Wrapper(impl)
}
