package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Day {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Day
}
object Day {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Day
  ): zio.aws.inspector2.model.Day = value match {
    case software.amazon.awssdk.services.inspector2.model.Day.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Day.SUN =>
      val r = SUN
      r
    case software.amazon.awssdk.services.inspector2.model.Day.MON =>
      val r = MON
      r
    case software.amazon.awssdk.services.inspector2.model.Day.TUE =>
      val r = TUE
      r
    case software.amazon.awssdk.services.inspector2.model.Day.WED =>
      val r = WED
      r
    case software.amazon.awssdk.services.inspector2.model.Day.THU =>
      val r = THU
      r
    case software.amazon.awssdk.services.inspector2.model.Day.FRI =>
      val r = FRI
      r
    case software.amazon.awssdk.services.inspector2.model.Day.SAT =>
      val r = SAT
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.UNKNOWN_TO_SDK_VERSION
  }
  case object SUN extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.SUN
  }
  case object MON extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.MON
  }
  case object TUE extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.TUE
  }
  case object WED extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.WED
  }
  case object THU extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.THU
  }
  case object FRI extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.FRI
  }
  case object SAT extends zio.aws.inspector2.model.Day {
    override def unwrap: software.amazon.awssdk.services.inspector2.model.Day =
      software.amazon.awssdk.services.inspector2.model.Day.SAT
  }
}
